/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.motherboard;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.WriteOnlyPortException;
import dioscuri.interfaces.Addressable;
import dioscuri.interfaces.Module;
import dioscuri.module.AbstractModule;
import dioscuri.module.ModuleMotherboard;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeviceDummy
extends AbstractModule
implements Addressable {
    private static final Logger logger = Logger.getLogger(DeviceDummy.class.getName());

    public DeviceDummy(Emulator emulator) {
        super(Module.Type.DUMMY, Module.Type.MOTHERBOARD);
    }

    @Override
    public boolean reset() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        for (int i = 0; i < moduleMotherboard.ioSpaceSize; ++i) {
            moduleMotherboard.setIOPort(i, this);
        }
        return true;
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleException {
        if (n == 146) {
            ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IN command (byte) to port " + Integer.toHexString(n).toUpperCase() + " received");
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Returned A20 value: " + Boolean.toString(moduleMotherboard.getA20()));
            return (byte)(moduleMotherboard.getA20() ? 2 : 0);
        }
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IN command (byte) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Returned default value 0xFF to AL");
        return -1;
    }

    @Override
    public void setIOPortByte(int n, byte by) throws ModuleException {
        if (n == 146) {
            ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " OUT command (byte) to port " + Integer.toHexString(n).toUpperCase() + " received");
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Set A20 value: " + by);
            moduleMotherboard.setA20((by & 2) == 2);
            return;
        }
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " OUT command (byte) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, WriteOnlyPortException {
        if (n == 146) {
            byte[] byArray;
            ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IN command (word) to port " + Integer.toHexString(n).toUpperCase() + " received");
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Returned A20 value");
            if (moduleMotherboard.getA20()) {
                byte[] byArray2 = new byte[2];
                byArray2[0] = 0;
                byArray = byArray2;
                byArray2[1] = 2;
            } else {
                byte[] byArray3 = new byte[2];
                byArray3[0] = 0;
                byArray = byArray3;
                byArray3[1] = 0;
            }
            return byArray;
        }
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " IN command (word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Returned default value 0xFFFF to AX");
        return new byte[]{-1, -1};
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException {
        if (n == 146) {
            ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " OUT command (word) to port " + Integer.toHexString(n).toUpperCase() + " received");
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Set A20 value");
            moduleMotherboard.setA20((byArray[1] & 2) == 2);
            return;
        }
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " OUT command (word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, WriteOnlyPortException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " IN command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Returned default value 0xFFFFFFFF to eAX");
        return new byte[]{-1, -1, -1, -1};
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " OUT command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }
}

